(function() {

try {
	Components.utils.import("resource:///modules/CustomizableUI.jsm");
	CustomizableUI.createWidget({
		id: "uc-restart",
		defaultArea: CustomizableUI.AREA_NAVBAR,
		removable: true,
		label: "Neustart",
		tooltiptext: "Neustart",
		onClick: function() {
			Services.appinfo.invalidateCachesOnRestart() || BrowserUtils.restartApplication();
		},
		onCreated: function(aNode) {
			aNode.style.listStyleImage = 'url("chrome://browser/skin/reload.svg")';
			return aNode;
		}
	});
} catch (e) {
	Components.utils.reportError(e);
};

})();
